<?php
/**
 * Small Plugin to make Google Webmaster Tools site verification a bit easier.
 * Works with the Meta Tag method and no template adjustements are needed.
 *
 * @author Michiel Bijland
 * @package plg_GoogleVerify
 * @version $Revision: 151 $
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

/* no direct access */
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.plugin.plugin' );

/**
 * Google Verify System Plugin
 *
 * @package	plg_GoogleVerify
 */
class plgSystemGoogleVerify extends JPlugin {
	/**
	 * Constructor
	 *
	 * For php4 compatability we must not use the __constructor as a constructor for plugins
	 * because func_get_args ( void ) returns a copy of all passed arguments NOT references.
	 * This causes problems with cross-referencing necessary for the observer design pattern.
	 *
	 * @access	protected
	 * @param	object		$subject The object to observe
	 */
	function plgSystemGoogleVerify(& $subject, $params) {
		parent::__construct($subject, $params);
	}

	function onAfterInitialise(){

		// Get Plugin info
		$pluginparams = $this->params;

		// get data
		$name = $pluginparams->get( 'name' );
		$content = $pluginparams->get( 'key' );
		if(empty($content)){
			return;
		}

		// get document
		$document	=& JFactory::getDocument();

		// set meta
		$document->setMetaData($name, $content);

	}
}
?>