<?php
/**
 * @copyright	Copyright (C) 2005 - 2008 Open Source Matters. All rights reserved.
 * @license		GNU/GPL, see LICENSE.php
 * Joomla! is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 */

// no direct access
defined('_JEXEC') or die('Restricted access');
// submit 404 header
if ($this->error->code == '404') {
    header("HTTP/1.0 404 Not Found");
}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="<?php echo $this->language; ?>" lang="<?php echo $this->language; ?>" dir="<?php echo $this->direction; ?>">
<head>
    <title><?php echo $this->error->code ?> - <?php echo $this->title; ?></title>
    <link rel="stylesheet" href="<?php echo $this->baseurl; ?>/templates/<?php echo $this->template?>/css/error.css" type="text/css" />
</head>
<body>

<?php if ($this->error->code == '404') {

    $mainframe =& JFactory::getApplication();
    echo '<div id="sitename">' . $mainframe->getCfg('sitename') . '</div>';
    ?>

    <div id="errormessage"><div id="error"><?php echo $this->error->code ?></div><?php echo $this->error->message ?>
    </div>

    <div id="content">
        <?php echo JText::_('You have reached a nonexistent or broken web-page.');
        echo '<br /><br />';
        echo JText::_('Please visit our ');
        echo '<b><a href="' . JURI::root() . '" title="' . JText::_('the home page') . '">' . JText::_('home page,') . '</a></b>';
        echo '<br /><br />';
        echo JText::_('use the main menu,');

        $items = &JSite::getMenu();	
        $rows = $items->getItems('menutype', 'mainmenu');

        echo '<ul>';
        foreach ($rows as $row) {
            if ($row->parent == '0' && $row->home == '0') { // only top level menues, whithout home page link
                echo '<li><a href="' . $this->baseurl . '/' . $row->alias . '" title="' . $row->name . '">' . $row->name . '</a></li>';
            }
        }
        echo '</ul>';
        ?>
        <form action="index.php" method="post">
            <div class="search">
                <?php echo JText::_('or search the site.'); ?>
                <input name="searchword" id="mod_search_searchword" class="inputbox" type="text" size="40" />
            </div>
            <input type="hidden" name="task"   value="search" />
            <input type="hidden" name="option" value="com_search" />
        </form>
    </div>

    <!-- Google Analytics tracking code. Placed in Event Tracking
    IMPORTANT: replace XXXXXXXXXXX on line 75 with Google Analytics site ID (number like UA-6774674-2) -->
    <!--
    <script type="text/javascript">
        var gaJsHost = (("https:" == document.location.protocol) ? "https://ssl." : "http://www.");
        document.write(unescape("%3Cscript src='" + gaJsHost + "google-analytics.com/ga.js' type='text/javascript'%3E%3C/script%3E"));
    </script>
    <script type="text/javascript">
        try {
            var pageTracker = _gat._getTracker("XXXXXXXXXXX");
            //pageTracker._trackPageview("/404.html?page=" + document.location.pathname + document.location.search + "&from=" + document.referrer);
            pageTracker._initData();
            pageTracker._trackEvent('404 Error', document.location.pathname, "Referrer: " + document.referrer + " & Search: " + document.location.search);
        } catch(err) {}
    </script>
    -->

<?php } else { ?>

    <div align="center">
        <div id="outline">
        <div id="errorboxoutline">
            <div id="errorboxheader"><?php echo $this->error->code ?> - <?php echo $this->error->message ?></div>
            <div id="errorboxbody">
            <p><strong><?php echo JText::_('You may not be able to visit this page because of:'); ?></strong></p>
                <ol>
                    <li><?php echo JText::_('An out-of-date bookmark/favourite'); ?></li>
                    <li><?php echo JText::_('A search engine that has an out-of-date listing for this site'); ?></li>
                    <li><?php echo JText::_('A mis-typed address'); ?></li>
                    <li><?php echo JText::_('You have no access to this page'); ?></li>
                    <li><?php echo JText::_('The requested resource was not found'); ?></li>
                    <li><?php echo JText::_('An error has occurred while processing your request.'); ?></li>
                </ol>
            <p><strong><?php echo JText::_('Please try one of the following pages:'); ?></strong></p>
            <p>
                <ul>
                    <li><a href="<?php echo $this->baseurl; ?>/index.php" title="<?php echo JText::_('Go to the home page'); ?>"><?php echo JText::_('Home Page'); ?></a></li>
                </ul>
            </p>
            <p><?php echo JText::_('If difficulties persist, please contact the system administrator of this site.'); ?></p>
            <div id="techinfo">
            <p><?php echo $this->error->message; ?></p>
            <p>
                <?php if($this->debug) :
                    echo $this->renderBacktrace();
                endif; ?>
            </p>
            </div>
            </div>
        </div>
        </div>
    </div>

<?php } ?>
<div id="note">[Developed by: <a href="http://justphp.net">www.justPHP.net</a>]</div>
</body>
</html>
